package org.nakedobjects.nof.core.adapter.value;

import java.awt.Image;


public class ImageAdapter extends AbstractImageAdapter {
    private Image image;

    public ImageAdapter() {
        image = null;
    }

    public ImageAdapter(Image image) {
        this.image = image;
    }

    public void clear() {
        image = null;
    }

    public int getHeight() {
        return isEmpty() ? 0 : image.getHeight(null);
    }

    public Image getImage() {
        return image;
    }

    public Object getObject() {
        return image;
    }

    protected int[][] getPixels() {
        return grabPixels(image);
    }

    public Class getValueClass() {
        return Image.class;
    }

    public int getWidth() {
        return isEmpty() ? 0 : image.getWidth(null);
    }

    public boolean isEmpty() {
        return image == null;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    protected void setPixels(int[][] pixels) {
        this.image = createImage(pixels);
    }

    public String toString() {
        return "ImageAdapter: " + image;
    }

}

// Copyright (c) Naked Objects Group Ltd.
