package org.nakedobjects.nof.core.adapter.value;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;

import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.noa.adapter.value.IntegerValue;
import org.nakedobjects.nof.core.conf.Configuration;
import org.nakedobjects.nof.core.context.NakedObjectsContext;


public class IntAdapter extends AbstractValueAdapter implements IntegerValue {
    private static final NumberFormat DEFAULT_FORMAT = NumberFormat.getNumberInstance();
    private NumberFormat format;
    private Integer value;


    public IntAdapter() {
        String formatRequired = NakedObjectsContext.getConfiguration().getString(Configuration.ROOT + "value.format.int");
        if (formatRequired == null) {
            format = DEFAULT_FORMAT;
        } else {
            setMask(formatRequired);
        }
    }

    public IntAdapter(final Integer value) {
        this();
        this.value = value;
    }

    // ///// titleString, icon, valueClass ///////

    public String titleString() {
        return isEmpty() ? "" : format.format(value);
    }

    public String getIconName() {
        return "int";
    }

    public Class getValueClass() {
        return Integer.class;
    }

    // ///// Accessor ///////


    public Integer integerValue() {
        return value;
    }

    public Object getObject() {
        return value;
    }

    // ///// Null Handling ///////

    public boolean canClear() {
        return true;
    }

    public void clear() {
        value = null;
    }

    public boolean isEmpty() {
        return value == null;
    }

    // ///// Mutator ///////

    public void setValue(final Integer value) {
        this.value = value;
    }

    protected void doParse(String entry) {
            try {
                value = new Integer(format.parse(entry).intValue());
            } catch (ParseException e) {
                throw new TextEntryParseException("Not an whole number " + entry, e);
            }
    }

    // ///// Encode, Decode ///////

    protected String doEncode() {
        return value.toString();
    }

    protected void doRestore(String data) {
            value = new Integer(data);
    }

    // ///// Semantics ///////

    public void setMask(String mask) {
        format = new DecimalFormat(mask);
    }

    public int defaultTypicalLength() {
        return 9;
    }

    // /////// toString ///////

    public String toString() {
        return "IntAdapter: " + value;
    }

}
// Copyright (c) Naked Objects Group Ltd.
