package org.nakedobjects.nof.core.adapter.value;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;

import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.noa.adapter.value.ShortValue;
import org.nakedobjects.nof.core.conf.Configuration;
import org.nakedobjects.nof.core.context.NakedObjectsContext;


public class ShortAdapter extends AbstractValueAdapter implements ShortValue {
    private static NumberFormat DEFAULT_FORMAT = NumberFormat.getNumberInstance();
    private NumberFormat format = DEFAULT_FORMAT;
    private Short value;

    public ShortAdapter() {
        String formatRequired = NakedObjectsContext.getConfiguration().getString(Configuration.ROOT + "value.format.short");
        if (formatRequired == null) {
            format = DEFAULT_FORMAT;
        } else {
            setMask(formatRequired);
        }
    }

    public ShortAdapter(final Short value) {
        this();
        this.value = value;
    }

    // ///// titleString, icon, valueClass ///////

    public String titleString() {
        return value == null ? "" : format.format(value);
    }

    public String getIconName() {
        return "short";
    }

    public Class getValueClass() {
        return Short.class;
    }

    // ///// Accessor ///////

    public Short shortValue() {
        return value;
    }

    public Object getObject() {
        return value;
    }

    // ///// Null Handling ///////

    public boolean canClear() {
        return true;
    }

    public void clear() {
        value = null;
    }

    public boolean isEmpty() {
        return value == null;
    }

    // ///// Mutator ///////

    public void setValue(final Short value) {
        this.value = value;
    }

    protected void doParse(String entry) {
        try {
            value = new Short(format.parse(entry).shortValue());
        } catch (ParseException e) {
            throw new TextEntryParseException("Not a whole number " + entry, e);
        }
    }

    // ///// Encode, Decode ///////

    protected String doEncode() {
        return value.toString();
    }

    protected void doRestore(String data) {
        value = new Short(data);
    }

    // ///// Semantics ///////

    public void setMask(String mask) {
        format = new DecimalFormat(mask);
    }

    public int defaultTypicalLength() {
        return 6;
    }

    // /////// toString ///////

    public String toString() {
        return "ShortAdapter: " + value;
    }

}
// Copyright (c) Naked Objects Group Ltd.
