package org.nakedobjects.nof.core.adapter.value;

import org.nakedobjects.noa.adapter.FieldRegEx;
import org.nakedobjects.noa.adapter.value.StringValue;


public class StringAdapter extends AbstractValueAdapter implements StringValue {
    private static final int DEFAULT_TYPICAL_LENGTH = 25;
    private String text;
    private String mask;
    private FieldRegEx regEx;

    public StringAdapter() {
        this.text = null;
    }

    public StringAdapter(final String text) {
        this.text = text;
    }

    protected String doEncode() {
        if (text.equals("NULL") || isEscaped(text)) {
            return escapeText(text);
        } else {
            return text;
        }
    }

    private boolean isEscaped(final String text) {
        return text.startsWith("/");
    }

    private String escapeText(final String text) {
        return "/" + text;
    }

    public boolean canClear() {
        return true;
    }

    public void clear() {
        text = null;
    }

    public String getIconName() {
        return "text";
    }

    public Object getObject() {
        return text;
    }

    public Class getValueClass() {
        return String.class;
    }

    public boolean isEmpty() {
        return text == null || text.equals("");
    }

    public boolean isEntryValid(final String text) {
        return regEx == null || RegExProcessor.isEntryValid(regEx, text);
    }

    protected void doParse(String entry) {
        if (regEx != null) {
            RegExProcessor.validateEntry(regEx, entry);
        }
        if (entry.trim().equals("")) {
            this.text = null;
        } else {
            this.text = entry;
        }
    }

    protected void doRestore(String data) {
        if (isEscaped(data)) {
            setValue(data.substring(1));
        } else {
            setValue(data);
        }
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public void setRegEx(FieldRegEx regEx) {
        this.regEx = regEx;
    }

    public void setValue(final String value) {
        text = value;
    }

    public String getRegExFormat() {
        return regEx == null ? null : regEx.getFormatExpression();
    }

    public String getRegExValidation() {
        return regEx == null ? null : regEx.getValidationExpression();
    }

    public boolean getRegExCaseSensitive() {
        return regEx == null ? false : regEx.isCaseSensitive();
    }

    public int defaultTypicalLength() {
        return DEFAULT_TYPICAL_LENGTH;
    }

    public String stringValue() {
        return text;
    }

    public String titleString() {
        String string = text == null ? "" : text;
        if (regEx != null && regEx.isFormat()) {
            string = RegExProcessor.formatEntry(regEx, string);
        }
        if (mask != null && mask.startsWith("u")) {
            string = string.toUpperCase();
        }
        return string;
    }

    public String toString() {
        return "StringAdapter: " + text;
    }

}
// Copyright (c) Naked Objects Group Ltd.
