package org.nakedobjects.nof.core.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;


public class PropertiesFileReader implements ConfigurationReader {
    private static final Logger LOG = Logger.getLogger(PropertiesFileReader.class);
    private Properties properties;
    private boolean found = false;

    public PropertiesFileReader(final String directory, final String fileName, final boolean ensureFileLoads) {
        properties = new Properties();
        File file = new File(directory, fileName);
        try {
            FileInputStream in;
            in = new FileInputStream(file);
            properties.load(in);
            found = true;
            LOG.info("configuration file " + file.getPath() + " loaded");
        } catch (FileNotFoundException e) {
            if (ensureFileLoads) {
                throw new NakedObjectRuntimeException("Could not find required configuration file: " + file.getPath());
            }
            LOG.info("configuration file " + file.getPath() + " not found, but not needed");
        } catch (IOException e) {
            throw new NakedObjectRuntimeException("Could not load configuration file " + file.getPath(), e);
        }
    }

    public Properties getProperties() {
        return properties;
    }

    boolean getFound() {
        return found;
    }

}
// Copyright (c) Naked Objects Group Ltd.
