package org.nakedobjects.nof.core.conf;

import org.nakedobjects.nof.core.util.NakedObjectConfiguration;

/**
 * Loads in the specified configuration files as resources on the classpath.
 * Properties in the later files overrides properties in earlier
 * files.
 */
public class ResourceConfigurationLoader extends DefaultConfigurationLoader {
    PropertiesConfiguration configuration = new PropertiesConfiguration();
    
	public ResourceConfigurationLoader() {
        super();
    }

    public ResourceConfigurationLoader(final String file) {
        super(file);
    }

	public NakedObjectConfiguration load() {

        if (configuration.getString(SHOW_EXPLORATION_OPTIONS) == null) {
            configuration.add(SHOW_EXPLORATION_OPTIONS, "yes");
        }
        return configuration;
    }
    
    public void addConfigurationFile(final String path, final boolean ensureLoaded) {
        PropertiesFileReader loader = new PropertiesFileReader(".", path, ensureLoaded);
        configuration.add(loader.getProperties());
    }

}
// Copyright (c) Naked Objects Group Ltd.