package org.nakedobjects.nof.core.context;

import java.io.Serializable;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.nof.core.persist.AbstractInstancesCriteria;

public class PerspectiveCriteria extends AbstractInstancesCriteria implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String username;

    protected PerspectiveCriteria() {
        username = null;
    }
    
    public PerspectiveCriteria(final String username) {
        super(NakedObjectsContext.getReflector().loadSpecification(Perspective.class), false);
        this.username = username;
    }

    public boolean matches(final NakedObject object) {
        return ((Perspective) object.getObject()).getUserName().equals(username);
    }

    public String getUserName() {
        return username;
    }

    public boolean matches(String username) {
        return this.username.equals(username);
    }
}


// Copyright (c) Naked Objects Group Ltd.
