package org.nakedobjects.nof.core.context;

import java.util.Enumeration;
import java.util.Vector;

import org.apache.log4j.Logger;

import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.ToString;


public class SimpleUpdateNotifier implements UpdateNotifier, DebugInfo {
    private static final Logger LOG = Logger.getLogger(SimpleUpdateNotifier.class);
    private Vector changes = new Vector();
    private Vector disposals = new Vector();

    public synchronized void addChangedObject(NakedObject object) {
        LOG.debug("mark as dirty " + object);
        if (!changes.contains(object)) {
            changes.addElement(object);
        }
    }

    public void addDisposedObject(NakedObject object) {
        LOG.debug("mark as disposed " + object);
        if (!disposals.contains(object)) {
            disposals.addElement(object);
        }

    }

    public synchronized Enumeration allChangedObjects() {
        Enumeration changedObjects = changes.elements();
        if (changes.size() > 0) {
            LOG.debug("dirty objects " + changes);
        }
        changes = new Vector();
        return changedObjects;
    }

    public synchronized Enumeration allDisposedObjects() {
        Enumeration disposedObjects = disposals.elements();
        if (disposals.size() > 0) {
            LOG.debug("disposed objects " + disposals);
        }
        disposals = new Vector();
        return disposedObjects;
    }

    public void debugData(DebugString debug) {
        debug.appendln("Changes");
        debugList(debug, changes);

        debug.appendln("Disposals");
        debugList(debug, disposals);
    }

    private void debugList(final DebugString debug, final Vector list) {
        debug.indent();
        if (list.size() == 0) {
            debug.appendln("none");
        } else {
            Enumeration enumeration = list.elements();
            while (enumeration.hasMoreElements()) {
                NakedObject adapter = (NakedObject) enumeration.nextElement();
                debug.appendln(adapter.toString());
            }
        }
        debug.unindent();
    }

    public String debugTitle() {
        return "Simple Update Notifier";
    }

    public void ensureEmpty() {
        if (changes.size() > 0) {
            throw new NakedObjectRuntimeException("Update notifier still has updates");
        }
    }

    public void init() {}

    public void shutdown() {
        LOG.info("  shutting down " + this);
        changes.removeAllElements();
        changes = null;
    }

    public String toString() {
        return new ToString(this).append("changes", changes).toString();
    }
}

// Copyright (c) Naked Objects Group Ltd.
