package org.nakedobjects.nof.core.context;

import org.nakedobjects.noa.adapter.NakedObjectLoader;
import org.nakedobjects.noa.persist.NakedObjectPersistor;
import org.nakedobjects.noa.reflect.NakedObjectReflector;
import org.nakedobjects.noa.security.Session;
import org.nakedobjects.nof.core.image.TemplateImageLoader;
import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.object.MessageBroker;


/**
 * Single-user implementation of NakedObjects that simply stores the components and returns them on request.
 */
public class StaticContext extends NakedObjectsContext implements ContextDebug {
    public static NakedObjectsContext createInstance() {
        return new StaticContext();
    }

    private MessageBroker messages = new SimpleMessageBroker();
    private UpdateNotifier updateNotifier = new SimpleUpdateNotifier();
    protected NakedObjectLoader objectLoader;
    protected NakedObjectPersistor objectPersistor;
    protected Session session;
    protected NakedObjectReflector reflector;
    protected TemplateImageLoader templateImageLoader;

    protected StaticContext() {}

    protected void terminateSession() {
        session = null;
    }

    public String debugTitle() {
        return "Naked Objects Client Repository";
    }

    public void debug(DebugString debug) {
        debug.appendAsHexln("hash", hashCode());
        debug.appendln("image tmpl", templateImageLoader);
        debug.appendln("reflector", reflector);
        debug.appendln("loader", objectLoader);
        debug.appendln("persistor", objectPersistor);
        debug.appendln("session", session);
    }

    public void debugAll(DebugString debug) {
        debug(debug);
        debug.appendln();

        debug(debug, objectLoader);
        debug(debug, objectPersistor);
    }

    private void debug(DebugString debug, Object object) {
        if (object instanceof DebugInfo) {
            DebugInfo d = (DebugInfo) object;
            debug.appendTitle(d.debugTitle());
            d.debugData(debug);
        } else {
            debug.appendln("no debug for " + object);
        }
    }

    protected String executionContextId() {
        return "#1" + (session == null ? "" : "/" + session.getUserName());
    }

    protected String[] allExecutionContextIds() {
        return new String[] { executionContextId() };
    }

    protected ContextDebug debugContext(String executionContextId) {
        return this;
    }

    protected MessageBroker messageBroker() {
        return messages;
    }

    protected NakedObjectLoader objectLoader() {
        return objectLoader;
    }

    protected NakedObjectPersistor objectPersistor() {
        return objectPersistor;
    }

    protected Session session() {
        return session;
    }

    protected UpdateNotifier updateNotifier() {
        return updateNotifier;
    }

    /**
     * Expose as a .NET property
     * 
     * @property
     */
    public void set_ObjectLoader(final NakedObjectLoader objectLoader) {
        setObjectLoader(objectLoader);
    }

    /**
     * Expose as a .NET property
     * 
     * @property
     */
    public void set_ObjectPersistor(final NakedObjectPersistor objectManager) {
        setObjectPersistor(objectManager);
    }

    /**
     * Expose as a .NET property
     * 
     * @property
     */
    public void set_SpecificationLoader(final NakedObjectReflector specificationLoader) {
        setReflector(specificationLoader);
    }

    /**
     * Expose as a .NET property
     * 
     * @property
     */
    public void set_TemplateImageLoader(TemplateImageLoader loader) {
        setTemplateImageLoader(loader);
    }

    public void setObjectLoader(final NakedObjectLoader objectLoader) {
        this.objectLoader = objectLoader;
    }

    public void setObjectPersistor(final NakedObjectPersistor objectManager) {
        this.objectPersistor = objectManager;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void clearSession() {
        session = null;
    }
    
    public void setReflector(final NakedObjectReflector specificationLoader) {
        this.reflector = specificationLoader;
    }

    public void setTemplateImageLoader(TemplateImageLoader loader) {
        this.templateImageLoader = loader;
    }

    protected NakedObjectReflector reflector() {
        return reflector;
    }

    protected TemplateImageLoader templateImageLoader() {
        return templateImageLoader;
    }

    public void shutdownSession() {
        if (objectLoader != null) {
            objectLoader.shutdown();
            objectLoader = null;
        }
        if (objectPersistor != null) {
            objectPersistor.shutdown();
            objectPersistor = null;
        }
    }
}
// Copyright (c) Naked Objects Group Ltd.
