package org.nakedobjects.nof.core.image.java;

import java.awt.Canvas;
import java.awt.Image;
import java.awt.MediaTracker;

import org.apache.log4j.Logger;
import org.nakedobjects.nof.core.image.TemplateImage;


/**
 * Many icons are based on the same image, but in different sizes and possibly different colours. The
 * ImageTemplate class loads and holds them image, and can provide it clients with the full sized images or
 * scaled images.
 */
class AwtTemplateImage implements TemplateImage {
    private final static Logger LOG = Logger.getLogger(AwtTemplateImage.class);

    static AwtTemplateImage create(java.awt.Image image) {
        if (image == null) {
            return null;
        }
        return new AwtTemplateImage(image);

    }

    private Image image;
    private MediaTracker mt = new MediaTracker(new Canvas());

    private AwtTemplateImage(final Image image) {
        if (image == null) {
            throw new NullPointerException();
        }
        this.image = image;
    }

    public Image getImage() {
        return image;
    }

    public Image getIcon(final int height) {
        Image iconImage;

        if (height == image.getHeight(null)) {
            iconImage = image;
        } else {
            iconImage = image.getScaledInstance(-1, height, java.awt.Image.SCALE_SMOOTH);

            if (iconImage != null) {
                mt.addImage(iconImage, 0);

                try {
                    mt.waitForAll();
                } catch (Exception e) {
                    e.printStackTrace();
                }

                if (mt.isErrorAny()) {
                    LOG.error("failed to create scaled image: " + iconImage + " " + mt.getErrorsAny()[0]);
                    mt.removeImage(iconImage);
                    iconImage = null;
                } else {
                    mt.removeImage(iconImage);
                    LOG.debug("image " + iconImage + " scaled to " + height);
                }
            }

            if (iconImage == null || iconImage.getWidth(null) == -1) {
                throw new RuntimeException("scaled image! " + iconImage.toString());
            }
        }


        return iconImage;
    }
}
// Copyright (c) Naked Objects Group Ltd.
