package org.nakedobjects.nof.core.persist;

import java.util.Vector;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.persist.NakedObjectPersistor;
import org.nakedobjects.nof.core.context.NakedObjectsContext;

/*
 * TODO the dependency on the app lib needs to removed.  Fixture and FixtureBuilder need to be mapped onto the applip classes.
 */
public abstract class AbstractFixtureBuilder {

    private final static Logger LOG = Logger.getLogger(AbstractFixtureBuilder.class);
    protected final Vector fixtures = new Vector();
    
    public void addFixture(Object fixture) {
        fixtures.addElement(fixture);
    }

    /**
     * Installs all {{@link #addFixture(Object) added fixtures} fixtures (ie as
     * returned by {@link #getFixtures()}).
     * 
     * <p>
     * Once done the set of fixtures is cleared (ie {@link #getFixtures()} returns
     * an empty array).
     */
    public final void installFixtures() {
        NakedObjectPersistor persistor = NakedObjectsContext.getObjectPersistor();        
        preInstallFixtures(persistor);
        installFixtures(persistor, getFixtures());
        postInstallFixtures(persistor);
        persistor.reset();
        fixtures.removeAllElements();
    }

    private void installFixtures(final NakedObjectPersistor persistor, final Object[] fixtures) {
        for (int i = 0, last = fixtures.length; i < last; i++) {
            Object fixture = fixtures[i];
            installFixture(persistor, fixture);
        }
    }

    private void installFixture(
            final NakedObjectPersistor persistor,
            Object fixture) {
        NakedObjectsContext.getObjectLoader().initDomainObject(fixture);
        
        // first, install any child fixtures (if this is a composite.
        Object[] childFixtures = getFixtures(fixture);
        installFixtures(persistor, childFixtures);
        
        // now, install the fixture itself
        try {
            LOG.info("installing fixture: " + fixture);
            persistor.startTransaction();
            installFixture(fixture);
            persistor.endTransaction();
            LOG.info("fixture installed");
        } catch (RuntimeException e) {
            LOG.error("installing fixture " + fixture.getClass().getName() + " failed; aborting ", e);
            try {
                persistor.abortTransaction();
            } catch (Exception e2) {
                LOG.error("failure during abort", e2);
            }
            throw e;
        }
    }

    /**
     * Returns as an array all fixtures that have been {@link #addFixture(Object) added}.
     */
    protected Object[] getFixtures() {
        return fixtures.toArray();
    }

    /**
     * Calls the fixtures installation method.
     * 
     * <p>
     * For example, in Java this is the <tt>install</tt> method.
     */
    protected abstract void installFixture(Object fixture);

    /**
     * Extract any child fixtures of the provided fixture.
     * 
     * <p>
     * For example, in Java this is the <tt>getFixtures()</tt> method
     * returning any array of objects.
     * 
     * @param fixture
     * @return
     */
    protected abstract Object[] getFixtures(Object fixture);
        
    
    protected void postInstallFixtures(final NakedObjectPersistor objectManager) {}

    protected void preInstallFixtures(final NakedObjectPersistor objectManager) {}
}
