package org.nakedobjects.nof.core.persist;

import org.nakedobjects.noa.persist.InstancesCriteria;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.noa.util.ByteEncoder;
import org.nakedobjects.nof.core.context.NakedObjectsContext;


public abstract class AbstractInstancesCriteria implements InstancesCriteria {
    private final String specification;
    private final boolean includeSubclasses;

    public AbstractInstancesCriteria(final NakedObjectSpecification specification, final boolean includeSubclasses) {
        this.specification = specification.getFullName();
        this.includeSubclasses = includeSubclasses;
    }

    /**
     * provided for serialization purposes only. 
     */
    protected AbstractInstancesCriteria() {
        specification = null;
        includeSubclasses = false;
    }

    protected final void doEncode(final ByteEncoder encoder) {
    }

    public NakedObjectSpecification getSpecification() {
        return NakedObjectsContext.getReflector().loadSpecification(specification);
    }

    public boolean includeSubclasses() {
        return includeSubclasses;
    }

    public int hashCode() {
        final int PRIME = 31;
        int result = 1;
        result = PRIME * result + (includeSubclasses ? 1231 : 1237);
        result = PRIME * result + ((specification == null) ? 0 : specification.hashCode());
        return result;
    }

    public boolean equals(final Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        final AbstractInstancesCriteria other = (AbstractInstancesCriteria) obj;
        if (includeSubclasses != other.includeSubclasses)
            return false;
        if (specification == null) {
            if (other.specification != null)
                return false;
        } else if (!specification.equals(other.specification))
            return false;
        return true;
    }
}

// Copyright (c) Naked Objects Group Ltd.
