package org.nakedobjects.nof.core.persist;

import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.persist.InstancesCriteria;
import org.nakedobjects.noa.persist.NakedObjectPersistor;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.adapter.InstanceCollectionVector;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nof.core.util.DebugString;


public abstract class AbstractObjectPersistor implements NakedObjectPersistor, DebugInfo {
    private OidGenerator oidGenerator;

    public abstract void abortTransaction();

    public Oid createTransientOid(final Object object) {
        return oidGenerator.createTransientOid(object);
    }

    public void convertPersistentToTransientOid(final Oid oid) {
        oidGenerator.convertPersistentToTransientOid(oid);
    }

    public void convertTransientToPersistentOid(final Oid oid) {
        oidGenerator.convertTransientToPersistentOid(oid);
    }

    public void debugData(final DebugString debug) {
        debug.appendTitle("OID Generator");
        oidGenerator.debugData(debug);
        debug.appendln();
    }

     public NakedCollection findInstances(final InstancesCriteria criteria) {
        if (criteria == null) {
            throw new NullPointerException();
        }
        NakedObject[] instances = getInstances(criteria);
        NakedObjectSpecification specification = criteria.getSpecification();
        NakedCollection collection = new InstanceCollectionVector(specification, instances);
        return collection;
    }

    protected abstract NakedObject[] getInstances(final InstancesCriteria criteria);

    public void init() {
        Assert.assertNotNull("OID generator required", oidGenerator);
        oidGenerator.init();
    }

    /**
     * Expose as a .NET property
     * 
     * @property
     */
    public void set_OidGenerator(final OidGenerator oidGenerator) {
        this.oidGenerator = oidGenerator;
    }

    public void setOidGenerator(final OidGenerator oidGenerator) {
        this.oidGenerator = oidGenerator;
    }

    public void shutdown() {
        oidGenerator.shutdown();
        oidGenerator = null;
    }
}
// Copyright (c) Naked Objects Group Ltd.
