package org.nakedobjects.nof.core.persist;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.util.ToString;

public class AllInstances extends AbstractInstancesCriteria {
    public AllInstances(final NakedObjectSpecification specification, final boolean includeSubclasses) {
        super(specification, includeSubclasses);
    }

    /**
     * Returns true so it matches all instances.
     */
    public boolean matches(final NakedObject object) {
        return true;
    }
    
    public String toString() {
        ToString str = ToString.createAnonymous(this);
        str.append("spec", getSpecification().getShortName());
        str.append("subclasses", includeSubclasses());
        return str.toString();
    }
}


// Copyright (c) Naked Objects Group Ltd.
