package org.nakedobjects.nof.core.persist;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;


public class PatternCriteria extends AbstractInstancesCriteria {
    private final NakedObject pattern;

    public NakedObject getPattern() {
        return pattern;
    }

    public PatternCriteria(final boolean includeSubclasses, final Object pattern) {
        this(NakedObjectsContext.getReflector().loadSpecification(pattern.getClass()), includeSubclasses, pattern);
    }

    public PatternCriteria(final NakedObjectSpecification specification, final boolean includeSubclasses, final Object pattern) {
        this(specification, includeSubclasses, NakedObjectsContext.getObjectLoader().getAdapterForElseCreateAdapterForTransient(pattern));
    }

    public PatternCriteria(final NakedObjectSpecification specification, final boolean includeSubclasses, final NakedObject pattern) {
        super(specification, includeSubclasses);
        this.pattern = pattern;
    }

    public boolean matches(final NakedObject object) {
        NakedObjectSpecification requiredType = pattern.getSpecification();
        return requiredType.equals(object.getSpecification()) && matchesPattern(pattern, object);
    }

    private boolean matchesPattern(final NakedObject pattern, final NakedObject instance) {
        NakedObject object = instance;
        NakedObjectSpecification nc = object.getSpecification();
        NakedObjectField[] fields = nc.getFields();

        for (int f = 0; f < fields.length; f++) {
            NakedObjectField fld = fields[f];

            // are ignoring internal collections - these probably should be considered
            // ignore non-persistent fields - there is no persisted field to compare against
            if (!fld.isPersisted()) {
                continue;
            }

            if (fld.isValue()) {
                // find the objects
                NakedValue reqd = (NakedValue) fld.get(pattern);
                NakedValue search = (NakedValue) fld.get(object);

                // if pattern contains empty value then it matches anything
                if (fld.isEmpty(pattern)) {
                    continue;
                }

                // compare the titles
                String r = reqd.titleString().toLowerCase();
                String s = search.titleString().toLowerCase();

                // if the pattern occurs in the object
                if (s.indexOf(r) == -1) {
                    return false;
                }
            } else if (fld.isObject()) {
                // find the objects
                NakedObject reqd = (NakedObject) fld.get(pattern);
                NakedObject search = (NakedObject) fld.get(object);

                // if pattern contains null reference then it matches anything
                if (reqd == null) {
                    continue;
                }

                // otherwise there must be a reference, else they can never
                // match
                if (search == null) {
                    return false;
                }

                if (reqd != search) {
                    return false;
                }
            }
        }

        return true;
    }

}
// Copyright (c) Naked Objects Group Ltd.
