package org.nakedobjects.nof.core.reflect;

import java.io.Serializable;

import org.nakedobjects.noa.reflect.Consent;


public abstract class AbstractConsent implements Serializable, Consent {

    /**
     * Returns an Allow (Allow.DEFAULT) object if true; Veto (Veto.DEFAULT) if false;
     */
    public final static Consent allow(boolean allow) {
        if (allow) {
            return Allow.DEFAULT;
        } else {
            return Veto.DEFAULT;
        }
    }

    /**
     * Returns a new Allow object if <code>allow</code> is true; a new Veto if false. The respective reason
     * is passed to the newly created object.
     */
    public final static Consent create(boolean allow, String reasonAllowed, String reasonVeteod) {
        if (allow) {
            return new Allow(reasonAllowed);
        } else {
            return new Veto(reasonVeteod);
        }
    }


    protected AbstractConsent() {
        this.exception = null;
        this.reason = null;
    }

    protected AbstractConsent(final String reason) {
        this.exception = null;
        this.reason = reason;
    }

    protected AbstractConsent(final RuntimeException exception) {
        this.exception = exception;
        this.reason = exception != null?exception.getMessage():null;
    }

    
    
    private final String reason;
    /**
     * Returns the persmission's reason
     */
    public String getReason() {
        return reason == null ? "" : reason;
    }

    private final RuntimeException exception;
    public RuntimeException getException() {
        return exception;
    }

    /**
     * Returns true if this object is giving permission.
     */
    public abstract boolean isAllowed();

    /**
     * Returns true if this object is NOT giving permission.
     */
    public abstract boolean isVetoed();

    public String toString() {
        return "Permission [type=" + (isVetoed() ? "VETOED" : "ALLOWED") + ", reason=" + reason + "]";
    }
}
// Copyright (c) Naked Objects Group Ltd.
