package org.nakedobjects.nof.core.security;

import java.io.File;

import org.nakedobjects.noa.security.SessionManager;
import org.nakedobjects.nof.core.conf.Configuration;
import org.nakedobjects.nof.core.context.NakedObjectsContext;


public class PasswordFileAuthenticatorInstaller implements AuthenticatorInstaller {

    private static final String DEFAULT_PASSWORD_FILE_LOCATION = "config/passwords";
    private static final String AUTH_PASSWORD_FILE_LOCATION_PROPERTY = "component.authenticator.file.location";

    public SessionManager createAuthenticationManager() {
        final StandardAuthenticationManager authenticationManager = new StandardAuthenticationManager();
        final String passwordFileName = NakedObjectsContext.getConfiguration().getString(
                Configuration.ROOT + AUTH_PASSWORD_FILE_LOCATION_PROPERTY, DEFAULT_PASSWORD_FILE_LOCATION);
        final PasswordFileAuthenticator passwordFileAuthenticator = new PasswordFileAuthenticator(new File(passwordFileName));
        authenticationManager.addAuthenticator(passwordFileAuthenticator);
        return authenticationManager;
    }

    public String getName() {
        return "file";
    }
}
