package org.nakedobjects.nof.core.security;

import java.io.Serializable;

import org.nakedobjects.noa.security.Session;
import org.nakedobjects.noa.util.ByteDecoder;
import org.nakedobjects.noa.util.ByteEncoder;
import org.nakedobjects.noa.util.Encodable;
import org.nakedobjects.nof.core.util.ToString;


public final class SimpleSession implements Session, Encodable, Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String code;
    private final String[] roles;

    /**
     * Defaults {@link #getValidationCode()} to empty string (<tt>""</tt>).
     * 
     * @param name
     * @param roles
     */
    public SimpleSession(final String name, String[] roles) {
        this(name, roles, "");
    }

    public SimpleSession(final String name, String[] roles, String code) {
        this.name = name;
        this.code = code;
        if (roles == null) {
            this.roles = new String[0];
        } else {
            this.roles = roles;
        }
    }

    public SimpleSession(ByteDecoder decoder) {
        name = decoder.getString();
        code = decoder.getString();
        roles = decoder.getList();
    }

    public String getValidationCode() {
        return code;
    }

    public String getUserName() {
        return name;
    }

    public String[] getRoles() {
        return roles;
    }

    public String toString() {
        ToString str = new ToString(this);
        str.append("name", name);
        str.append("code", code);
        return str.toString();
    }

    public void encode(ByteEncoder encoder) {
        encoder.add(name);
        encoder.add(code);
        encoder.add(roles);
    }

}
// Copyright (c) Naked Objects Group Ltd.
