package org.nakedobjects.nof.core.service;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

import org.nakedobjects.applib.Filter;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.persist.InstancesCriteria;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.persist.AllInstances;
import org.nakedobjects.nof.core.persist.TitleCriteria;


/*
 * TODO the dependency on the app lib (to Filter) needs to removed.
 */
public class RepositoryHelper {

    public static Object[] allInstances(Class cls, boolean includeSubclasses) {
        return allInstances(NakedObjectsContext.getReflector().loadSpecification(cls), cls, includeSubclasses);
    }

    public static Object[] allInstances(final NakedObjectSpecification spec, final Class cls, final boolean includeSubclasses) {
        NakedCollection instances = NakedObjectsContext.getObjectPersistor().findInstances(
                new AllInstances(spec, includeSubclasses));
        Object[] array = convertToArray(instances, cls);
        return array;
    }

    private static List convertToList(final NakedCollection instances, final Class cls) {
        final List list = new ArrayList();
        final Enumeration e = instances.elements();
        while (e.hasMoreElements()) {
            list.add(((NakedObject) e.nextElement()).getObject());
        }
        return list;
    }

    private static Object[] convertToArray(final NakedCollection instances, final Class cls) {
        return convertToList(instances, cls).toArray();
    }

    /**
     * As per {@link #filteredInstances(org.nakedobjects.nof.core.service.AbstractRepository.Filter)}, but
     * using {@link #allInstances(Class, boolean)}.
     * 
     * @param filter
     * @param cls
     * @param includeSubclasses
     * @return
     */
    public static List filteredInstances(final Filter filter, final Class cls, final boolean includeSubclasses) {
        List filtered = new ArrayList();
        Object[] allInstances = allInstances(cls, includeSubclasses);
        for (int i = 0; i < allInstances.length; i++) {
            Object instance = allInstances[i];
            if (filter.accept(instance)) {
                filtered.add(instance);
            }
        }
        return filtered;
    }

    public static List findByCriteria(final InstancesCriteria criteria, final Class cls) {
        NakedCollection instances = NakedObjectsContext.getObjectPersistor().findInstances(criteria);
        return convertToList(instances, cls);

    }

    public static List findByTitle(final Class cls, final boolean includeSubclasses, final String title) {
        return findByTitle(NakedObjectsContext.getReflector().loadSpecification(cls), cls, includeSubclasses, title);
    }

    public static List findByTitle(
            final NakedObjectSpecification spec,
            final Class cls,
            final boolean includeSubclasses,
            final String title) {
        InstancesCriteria criteria = new TitleCriteria(spec, title, includeSubclasses);
        return findByCriteria(criteria, cls);
    }

    /**
     * As per {@link #firstFilteredInstance(org.nakedobjects.nof.core.service.AbstractRepository.Filter)},
     * but using {@link #allInstances(Class, boolean)}.
     * 
     * @param filter
     * @param cls
     * @param includeSubclasses
     * @return
     */
    public static Object firstFilteredInstance(final Filter filter, final Class cls, final boolean includeSubclasses) {
        List filteredInstances = filteredInstances(filter, cls, includeSubclasses);
        return filteredInstances.size() > 0 ? filteredInstances.get(0) : null;
    }

    public static boolean hasInstances(final Class cls, final boolean includeSubclasses) {
        return hasInstances(NakedObjectsContext.getReflector().loadSpecification(cls), includeSubclasses);
    }

    public static boolean hasInstances(final NakedObjectSpecification spec, final boolean includeSubclasses) {
        return NakedObjectsContext.getObjectPersistor().hasInstances(spec, includeSubclasses);
    }

}
// Copyright (c) Naked Objects Group Ltd.
