package org.nakedobjects.nof.core.service;

import java.util.Enumeration;
import java.util.Vector;

import org.nakedobjects.nof.core.system.ServicesInstaller;

public class ServicesLoader implements ServicesInstaller {
    private final Vector services = new Vector();

    public void addService(Object service) {
        if(service instanceof Vector) {
            Vector serviceVector = (Vector)service;
            Enumeration serviceEnum = serviceVector.elements();
            while(serviceEnum.hasMoreElements()) {
                services.addElement(serviceEnum.nextElement());
            }
        } else {
            services.addElement(service);
        }
    }
    
    public void addSimpleRepository(Class cls) {
        addService(new SimpleRepository(cls));
    }

    public Object[] getServices(boolean forServer) {
        Object[] serviceArray = new Object[services.size()];
        services.copyInto(serviceArray);
        return serviceArray;
    }

    public String getName() {
        return "services-loader";
    }
}


// Copyright (c) Naked Objects Group Ltd.
