package org.nakedobjects.nof.core.system;

import org.nakedobjects.nof.core.util.Assert;


public class InstanceFactory {

    public static Object createInstance(final String className) {
        return createInstance(className, null, null);
    }

    public static Object createInstance(final String className, final Class requiredClass) {
        return createInstance(className, null, requiredClass);
    }

    public static Object createInstance(final String className, final Class defaultType, final Class requiredClass) {
        Assert.assertNotNull("Class to instantiate must be specified", className);
        Class cls = null;
        try {
            cls = Class.forName(className);
            if(cls == null) {
                throw new InstanceCreationClassException("Failed to load class " + className);
            }
            if (requiredClass == null || requiredClass.isAssignableFrom(cls)) {
                return cls.newInstance();
            } else {
                throw new InstanceCreationClassException("Class " + className + " must be of the type " + requiredClass);
            }
        } catch (ClassNotFoundException e) {
            throw new UnavailableClassException("The class " + className + " cannot be found");
        } catch (NoClassDefFoundError e) {
            throw new InstanceCreationClassException("Class found " + className + ", but is missing a dependent class: " + e.getMessage(), e);
        } catch (InstantiationException e) {
            throw new InstanceCreationException("Could not instantiate an object of class " + cls.getName() + "; " + e.getMessage());
        } catch (IllegalAccessException e) {
            throw new InstanceCreationException("Could not access the class " + cls.getName() + "; " + e.getMessage());
        }
    }
    
    
}
// Copyright (c) Naked Objects Group Ltd.
