package org.nakedobjects.nof.core.system;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;

public class Monitor {
    private static final Logger LOG = Logger.getLogger(Monitor.class);
    private static List listeners = new ArrayList();
    
    public static void addListener(final MonitorListener listener) {
        listeners.add(listener);
    }
    
    public static void removeListener(final MonitorListener listener) {
        listeners.remove(listener);
    }
    
    public static void addEvent(final String category, final String message) {
        MonitorEvent event = new MonitorEvent(category, message);
        LOG.info(event);
        dispatchEvent(event);
    }

    private static void dispatchEvent(MonitorEvent event) {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            MonitorListener listener = (MonitorListener) iterator.next();
            listener.postEvent(event);
        }
    }
}


// Copyright (c) Naked Objects Group Ltd.
