package org.nakedobjects.nof.core.undo;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.OneToOneAssociation;


public class AssociateCommand implements Command {
    private final String description;
    private final OneToOneAssociation field;
    private final NakedObject object;
    private final NakedObject associatedObject;
    private String name;

    public AssociateCommand(final NakedObject object, final NakedObject associatedObject, final OneToOneAssociation field) {
        this.description = "Clear association of " + associatedObject.titleString();
        this.name = "associate " + associatedObject.titleString();
        this.object = object;
        this.associatedObject = associatedObject;
        this.field = field;
    }

    public String getDescription() {
        return description;
    }

    public String getName() {
        return name;
    }

    public void undo() {
        field.clearAssociation(object, associatedObject);
    }

    public void execute() {
        field.setAssociation(object, associatedObject);
    }
}
// Copyright (c) Naked Objects Group Ltd.
