package org.nakedobjects.nof.core.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.TimeZone;


public class PrintLocale {
    public static void main(String[] args) {
        if (args.length >= 2) {
            String localeSetting = args[0];
            System.out.println("Setting Locale to " + localeSetting + "\n");
            Locale.setDefault(new Locale(localeSetting));
            
            String timezoneSetting = args[1];
            System.out.println("Setting TimeZone to " + timezoneSetting + "\n");
            TimeZone.setDefault(TimeZone.getTimeZone(timezoneSetting));
        }

        Locale locale = Locale.getDefault();
        System.out.println("Locale");
        System.out.println("Code: " + locale.toString());
        try {
            System.out.println("Country: " + locale.getISO3Country());
        } catch (MissingResourceException e) {
            System.out.println("Country: " + e.getMessage());
        }
        try {
            System.out.println("Language: " + locale.getISO3Language());
        } catch (MissingResourceException e) {
            System.out.println("Language: " + e.getMessage());
        }

        System.out.println("\nTimezone");
        TimeZone timezone = TimeZone.getDefault();
        System.out.println("Code: " + timezone.getID());
        System.out.println("Name: " + timezone.getDisplayName());
        System.out.println("Offset: " + timezone.getRawOffset() / (1000 * 60 * 60));
        System.out.println("DST: " + timezone.getDSTSavings() / (1000 * 60 * 60));
    }
}

// Copyright (c) Naked Objects Group Ltd.
