package org.nakedobjects.object;

/**
 * Indicate that the implementing class might have dependencies that need to be set up (and hence also shut down).
 */
public interface RequiresSetup {

    /**
     * Indicates to the component that it is to initialise itself as it will soon be receiving requests.
     */
    void init();

    /**
     * Indicates to the component that no more requests will be made of it and it can safely release any
     * services it has hold of.
     */
    void shutdown();

}
// Copyright (c) Naked Objects Group Ltd.
