package org.nakedobjects.nof.core.adapter.map;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.context.StaticContext;
import org.nakedobjects.nof.testsystem.TestPojo;
import org.nakedobjects.nof.testsystem.TestProxyOid;
import org.nakedobjects.nof.testsystem.TestProxyReflector;
import org.nakedobjects.testing.TestSession;

import junit.framework.TestCase;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ObjectLoaderImplTest extends TestCase {
    
    private ObjectLoaderImpl objectLoader;

    protected void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);

        objectLoader = new ObjectLoaderImpl() {
            public void initDomainObject(Object domainObject) {}
        };
        
        NakedObjectsContext nakedObjects = StaticContext.createInstance();

        nakedObjects.setReflector(new TestProxyReflector());
        nakedObjects.setObjectLoader(objectLoader);
        nakedObjects.setSession(new TestSession());

        NakedObjectsContext.getReflector().init();
        NakedObjectsContext.getObjectLoader().init();
        
    }
    
    public void testRecreateTransientAdapter() {
        Oid oid = new TestProxyOid(13, false);
        Object object = new TestPojo();
        NakedObject adapter = objectLoader.recreateAdapter(oid,  object);
        assertEquals(oid, adapter.getOid());
        assertEquals(object, adapter.getObject());
        assertEquals(ResolveState.TRANSIENT, adapter.getResolveState());
        assertEquals(null, adapter.getVersion());
    }
  

    public void testRecreatePersistentAdapter() {
        Oid oid = new TestProxyOid(15, true);
        Object object = new TestPojo();
        NakedObject adapter = objectLoader.recreateAdapter(oid,  object);
        assertEquals(oid, adapter.getOid());
        assertEquals(object, adapter.getObject());
        assertEquals(ResolveState.GHOST, adapter.getResolveState());
        assertEquals(null, adapter.getVersion());
    }
  
}


// Copyright (c) Naked Objects Group Ltd.
