package org.nakedobjects.nof.core.adapter.value;

import junit.framework.TestCase;

import org.nakedobjects.noa.adapter.InvalidEntryException;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.testing.TestSystem;


public abstract class AbstractPrimitiveAdapterTestCase extends TestCase {

    protected NakedValue value;

    protected void setUp() throws Exception {
        new TestSystem().init();
    }

    public void testParseNull() throws Exception {
        try {
            value.parseTextEntry(null);
            fail();
        } catch (IllegalArgumentException expected) {}
    }

    public void testParseEmptyString() throws Exception {
        try {
            value.parseTextEntry("");
            fail();
        } catch (InvalidEntryException expected) {}
    }

    public void testIsEmpty() throws Exception {
        assertFalse(value.isEmpty());
    }

    public void testCanClear() throws Exception {
        assertFalse(value.canClear());
    }

    public void testToStringDoesNotThrowException() {
       value.toString();
    }

}
// Copyright (c) Naked Objects Group Ltd.
