package org.nakedobjects.nof.core.adapter.value;

import java.math.BigDecimal;
import java.math.BigInteger;

import org.nakedobjects.noa.adapter.TextEntryParseException;


public class BigIntAdapterTest extends AbstractValueAdapterTestCase {

    private BigIntegerAdapter value;

    protected void setUp() throws Exception {
        super.setUp();
        super.value = value = new BigIntegerAdapter(new BigInteger("132199"));
    }

    public void testParseValidString() throws Exception {
        value.parseTextEntry("2142342334");
        assertEquals(new BigInteger("2142342334"), value.bigIntegerValue());
    }

    public void testParseInvalidString() throws Exception {
        try {
            value.parseTextEntry("214xxx2342334");
            fail();
        } catch (TextEntryParseException expected) {}
    }

    public void testTitle() throws Exception {
        assertEquals("132,199", value.titleString());    
    }
    
    public void testEncode() throws Exception {
        assertEquals("132199", value.asEncodedString());
    }
    
    public void testDecode() throws Exception {
        value.restoreFromEncodedString("432289991");
        assertEquals(new BigInteger("432289991"), value.bigIntegerValue());
    }

}

// Copyright (c) Naked Objects Group Ltd.
