package org.nakedobjects.nof.core.adapter.value;

import org.nakedobjects.noa.adapter.TextEntryParseException;


public class BooleanAdapterTest extends AbstractValueAdapterTestCase {

    private BooleanAdapter value;

    protected void setUp() throws Exception {
        super.setUp();
        super.value = value = new BooleanAdapter(new Boolean(true));
    }

    public void testParseFalseString() throws Exception {
        value.parseTextEntry("faLSe");
        assertEquals(new Boolean(false), value.booleanValue());
    }
    

    public void testParseTrueString() throws Exception {
        value.parseTextEntry("TRue");
        assertEquals(new Boolean(true), value.booleanValue());
    }


    public void testParseInvalidString() throws Exception {
        try {
            value.parseTextEntry("yes");
            fail();
        } catch (TextEntryParseException expected) {}
    }

    public void testTitle() throws Exception {
        assertEquals("True", value.titleString());    
    }
    
    public void testTitleWhenNotSet() throws Exception {
        value.reset();
        assertEquals("False", value.titleString());
    }

    public void testEncode() throws Exception {
        assertEquals("T", value.asEncodedString());
    }
    
    public void testDecode() throws Exception {
        value.restoreFromEncodedString("T");
        assertEquals(new Boolean(true), value.booleanValue());
    }


    public void testIsSet() {
        assertEquals(true, value.isSet());
    }
    
    public void testIsNotSet() {
        value.reset();
        assertEquals(false, value.isSet());
    }
}

// Copyright (c) Naked Objects Group Ltd.
