package org.nakedobjects.nof.core.adapter.value;

import org.nakedobjects.noa.adapter.TextEntryParseException;


public class ByteAdapterTest extends AbstractValueAdapterTestCase {

    private ByteAdapter value;

    protected void setUp() throws Exception {
        super.setUp();
        super.value = value = new ByteAdapter(new Byte((byte) 102));
    }

    public void testParseValidString() throws Exception {
        value.parseTextEntry("21");
        assertEquals(new Byte((byte) 21), value.byteValue());
    }

    public void testParseInvalidString() throws Exception {
        try {
            value.parseTextEntry("xs21z4xxx23");
            fail();
        } catch (TextEntryParseException expected) {}
    }

    public void testTitle() throws Exception {
        assertEquals("102", value.titleString());    
    }
    
    public void testEncode() throws Exception {
        assertEquals("102", value.asEncodedString());
    }
    
    public void testDecode() throws Exception {
        value.restoreFromEncodedString("-91");
        assertEquals(new Byte((byte) -91), value.byteValue());
    }

}

// Copyright (c) Naked Objects Group Ltd.
