package org.nakedobjects.nof.core.adapter.value;

import java.sql.Date;
import java.util.Calendar;
import java.util.TimeZone;

import org.nakedobjects.noa.adapter.TextEntryParseException;


public class DateTimeAdapterTest extends AbstractValueAdapterTestCase {

    public static void main(final String[] args) {
        junit.textui.TestRunner.run(DateTimeAdapterTest.class);
    }

    private DateTimeAdapter adapter;

    protected void setUp() throws Exception {
        super.setUp();
        Date date = new Date(0);
        super.value = adapter = new DateTimeAdapter(date);
    }

    public void testDateValue() {
        assertEquals(new Date(0), adapter.dateValue());

        adapter.setValue(new Date(50000));
        assertEquals(new Date(50000), adapter.dateValue());
    }

    public void testInvalidParse() throws Exception {
        try {
            adapter.parseTextEntry("date");
            fail();
        } catch (TextEntryParseException expected) {}
    }

    public void testLengths() {
        assertEquals(0, adapter.getMaximumLength());
        assertEquals(0, adapter.getMinumumLength());
    }

    public void testOutputAsString() {
        adapter.setMask("yyyy-MM-dd hh:mm");
        assertEquals("1970-01-01 12:00", adapter.titleString());
    }

    public void testParse() throws Exception {
        adapter.setMask("yyyy-MM-dd hh:mm");
        adapter.parseTextEntry("1980-01-01 10:40");

        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
        calendar.set(1980, 0, 1, 10, 40, 0);
        calendar.set(Calendar.MILLISECOND, 0);

        assertEquals(calendar.getTime(), adapter.dateValue());
    }

}
// Copyright (c) Naked Objects Group Ltd.
