package org.nakedobjects.nof.core.adapter.value;

import junit.framework.TestCase;

import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.nof.core.adapter.value.DoubleAdapter;
import org.nakedobjects.testing.TestSystem;


public class DoubleAdapterTest extends AbstractValueAdapterTestCase {

    public static void main(final String[] args) {
        junit.textui.TestRunner.run(DoubleAdapterTest.class);
    }

    private DoubleAdapter value;

    protected void setUp() throws Exception {
        new TestSystem().init();
       super.value = value = new DoubleAdapter(new Double(32.5d));
    }

    public void testValue() {
        assertEquals(32.5, value.doubleValue().doubleValue(), 0.0);
    }

    public void testInvalidParse() throws Exception {
        try {
            value.parseTextEntry("one");
            fail();
        } catch (TextEntryParseException expected) {}
    }

    public void testLengths() {
        assertEquals(0, value.getMaximumLength());
        assertEquals(0, value.getMinumumLength());
    }

    public void testOutputAsString() {
        assertEquals("32.5", value.titleString());

        value.setValue(Double.valueOf(35000000.0));
        assertEquals("35,000,000", value.titleString());
    }

    public void testParse() throws Exception {
        value.parseTextEntry("120.56");
        assertEquals(120.56, value.doubleValue().doubleValue(), 0.0);

        value.parseTextEntry("1,20.0");
        assertEquals(120, value.doubleValue().doubleValue(), 0.0);
    }
}
// Copyright (c) Naked Objects Group Ltd.
