package org.nakedobjects.nof.core.adapter.value;

import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.testing.TestSystem;


public class LongAdapterTest extends AbstractValueAdapterTestCase {

    public static void main(final String[] args) {
        junit.textui.TestRunner.run(LongAdapterTest.class);
    }

    private LongAdapter value;

    protected void setUp() throws Exception {
        new TestSystem().init();
         super.value = value = new LongAdapter(new Long(32));
    }

    public void testIntegerValue() {
        assertEquals(32,  value.longValue().longValue());
    }

    public void testInvalidParse() throws Exception {
        try {
             value.parseTextEntry("one");
            fail();
        } catch (TextEntryParseException expected) {}
    }

    public void testLengths() {
        assertEquals(0,  value.getMaximumLength());
        assertEquals(0,  value.getMinumumLength());
    }

    public void testOutputAsString() {
        assertEquals("32",  value.titleString());

         value.setValue(Long.valueOf(-128L));
        assertEquals("-128",  value.titleString());
    }

    public void testParse() throws Exception {
         value.parseTextEntry("120");
        assertEquals(120,  value.longValue().longValue());

         value.parseTextEntry("1,20.0");
        assertEquals(120,  value.longValue().longValue());
    }
}
// Copyright (c) Naked Objects Group Ltd.
