package org.nakedobjects.nof.core.adapter.value;



public class StringAdapterTest extends AbstractValueAdapterTestCase {

    public static void main(final String[] args) {
        junit.textui.TestRunner.run(StringAdapterTest.class);
    }

    private StringAdapter value;

    protected void setUp() throws Exception {
        super.setUp();
        super.value = value = new StringAdapter("text entry");
    }

    public void testStringValue() {
        assertEquals("text entry", value.stringValue());
    }

    public void testLengths() {
        assertEquals(0, value.getMaximumLength());
        assertEquals(0, value.getMinumumLength());
    }

    public void testOutputAsString() {
        assertEquals("text entry", value.titleString());
    }

    public void testParse() throws Exception {
        value.parseTextEntry("tRUe");
        assertEquals("tRUe", value.stringValue());

        value.parseTextEntry("fALse");
        assertEquals("fALse", value.stringValue());
    }
    
    public void testEncodeNormalString() throws Exception {
        value = new StringAdapter("/slash");
        assertEquals("//slash", value.asEncodedString());
    }
    
    public void testEncodeNULLString() throws Exception {
        value = new StringAdapter("NULL");
        assertEquals("/NULL", value.asEncodedString());
    }
    
    public void testRestore() throws Exception {
        value.restoreFromEncodedString("//slash");
        assertEquals("/slash", value.stringValue());
    }
    
    public void testRestoreNULLString() throws Exception {
        value.restoreFromEncodedString("/NULL");
        assertEquals("NULL", value.stringValue());    
    }
}
// Copyright (c) Naked Objects Group Ltd.
