package org.nakedobjects.nof.core.adapter.value;

import java.sql.Time;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

import org.nakedobjects.applib.value.TestClock;


public class TimeAdapterTest extends AbstractValueAdapterTestCase {
    private Time twoOClock;
    private TimeAdapter value;

    protected void setUp() throws Exception {
        super.setUp();

        Locale.setDefault(Locale.US);
        TimeZone.setDefault(TestClock.timeZone);
        // twoOClock = new Time(14 * 60 * 60 * 1000);

        Calendar c = Calendar.getInstance();
        c.setTimeZone(TestClock.timeZone);

        c.set(Calendar.MILLISECOND, 0);

        c.set(Calendar.YEAR, 0);
        c.set(Calendar.MONTH, 0);
        c.set(Calendar.DAY_OF_MONTH, 0);

        c.set(Calendar.HOUR_OF_DAY, 14);
        c.set(Calendar.MINUTE, 0);
        c.set(Calendar.SECOND, 0);

        twoOClock = new Time(c.getTimeInMillis());

        super.value = value = new TimeAdapter(twoOClock);
    }

    public void testNewEmptyTime() {
        TimeAdapter adapter = new TimeAdapter();
        assertTrue(adapter.isEmpty());
        assertEquals("NULL", adapter.asEncodedString());
    }

    public void testNewTime() {

        assertEquals("140000000", value.asEncodedString());
    }

    public void testAdd() {
        TimeAdapter adapter = new TimeAdapter(twoOClock);
        adapter.add(0, 0, 0, 1, 15);
        assertEquals("151500000", adapter.asEncodedString());
    }

    public void testAdd2() {
        TimeAdapter adapter = new TimeAdapter(twoOClock);
        adapter.add(0, 0, 0, 0, 0);
        assertEquals("140000000", adapter.asEncodedString());
    }
}

// Copyright (c) Naked Objects Group Ltd.
