package org.nakedobjects.nof.core.persist;

import org.nakedobjects.nof.core.persist.SerialOid;

import junit.framework.TestCase;


public class SerialOidTest extends TestCase {

    public static void main(final String[] args) {
        junit.textui.TestRunner.run(SerialOidTest.class);
    }

    public void testEquals() {
        SerialOid oid1 = SerialOid.createTransient(123);
        SerialOid oid2 = SerialOid.createTransient(123);
        SerialOid oid3 = SerialOid.createTransient(321);
        SerialOid oid4 = SerialOid.createPersistent(321);
        SerialOid oid5 = SerialOid.createPersistent(456);
        SerialOid oid6 = SerialOid.createPersistent(456);

        assertTrue(oid1.equals(oid2));
        assertTrue(oid2.equals(oid1));

        assertFalse(oid1.equals(oid3));
        assertFalse(oid3.equals(oid1));

        assertTrue(oid5.equals(oid6));
        assertTrue(oid6.equals(oid5));

        assertFalse(oid4.equals(oid5));
        assertFalse(oid5.equals(oid4));

        assertFalse(oid3.equals((Object) oid4));
        assertFalse(oid4.equals((Object) oid3));

        assertFalse(oid3.equals(oid4));
        assertFalse(oid4.equals(oid3));
    }

    public void testHashCode() {
        SerialOid oid1 = SerialOid.createTransient(123);
        SerialOid oid2 = SerialOid.createTransient(123);
        SerialOid oid3 = SerialOid.createTransient(321);
        SerialOid oid4 = SerialOid.createPersistent(321);
        SerialOid oid5 = SerialOid.createPersistent(456);
        SerialOid oid6 = SerialOid.createPersistent(456);

        assertEquals(oid1.hashCode(), oid2.hashCode());
        assertFalse(oid1.hashCode() == oid3.hashCode());

        assertEquals(oid5.hashCode(), oid6.hashCode());
        assertFalse(oid4.hashCode() == oid5.hashCode());

        assertFalse(oid3.hashCode() == oid4.hashCode());
    }

    public void testCopy() {
        SerialOid oid1 = SerialOid.createTransient(123);
        SerialOid oid3 = SerialOid.createTransient(321);

        assertFalse(oid1.hashCode() == oid3.hashCode());

        oid1.copyFrom(oid3);

        assertEquals(oid1.hashCode(), oid3.hashCode());
    }

    public void testStringAsHex() {
        assertEquals("TOID#7B", SerialOid.createTransient(123).toString());
        assertEquals("OID#80", SerialOid.createPersistent(128).toString());
    }

    public void testMakePersistent() {
        SerialOid oid1 = SerialOid.createTransient(123);

        assertNull(oid1.getPrevious());

        oid1.makePersistent(567);

        assertEquals(567, oid1.getSerialNo());
        assertEquals(false, oid1.isTransient());
        assertEquals(oid1.getPrevious(), SerialOid.createTransient(123));
    }

}
// Copyright (c) Naked Objects Group Ltd.
