package org.nakedobjects.nof.testsystem;

import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.nof.core.persist.OidGenerator;
import org.nakedobjects.nof.core.util.DebugString;


public class TestProxyOidGenerator implements OidGenerator {
    private int transientId = 1;
    private int persistentId = 90000;

    private Oid createOid() {
        return new TestProxyOid(transientId++);
    }

    public String name() {
        return "";
    }

    public void init() {}

    public void shutdown() {}

    public Oid createTransientOid(final Object object) {
        return createOid();
    }

    public void convertTransientToPersistentOid(final Oid oid) {
        ((TestProxyOid) oid).makePersistent(persistentId++);
        ((TestProxyOid) oid).previous = createOid();
    }

    public void convertPersistentToTransientOid(final Oid oid) {}

    public void debugData(final DebugString debug) {}

    public String debugTitle() {
        return null;
    }

}
// Copyright (c) Naked Objects Group Ltd.
