package org.nakedobjects.nof.testsystem;

import org.nakedobjects.noa.adapter.Version;

import java.util.Date;


public class TestProxyVersion implements Version {
    private static final long serialVersionUID = 1L;
    private final int value;

    public TestProxyVersion() {
        this(1);
    }

    public TestProxyVersion(final int value) {
        this.value = value;
    }

    public boolean equals(final Object obj) {
        if (obj instanceof TestProxyVersion) {
            TestProxyVersion other = (TestProxyVersion) obj;
            return other.value == value;
        }

        return false;
    }

    public boolean different(final Version version) {
        return value != ((TestProxyVersion) version).value;
    }

    public String toString() {
        return "Version#" + value;
    }

    public String getUser() {
        return "USER";
    }

    public Date getTime() {
        return new Date(0);
    }

    public Version next() {
        return new TestProxyVersion(value + 1);
    }
    
    public String sequence() {
        return "" + value;
    }

}
// Copyright (c) Naked Objects Group Ltd.
