package org.nakedobjects.nof.testsystem.tests;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.testsystem.TestPojo;
import org.nakedobjects.nof.testsystem.TestProxyNakedObject;
import org.nakedobjects.nof.testsystem.TestProxyOid;
import org.nakedobjects.nof.testsystem.TestProxySystem;
import org.nakedobjects.nof.testsystem.TestProxyVersion;

import junit.framework.TestCase;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;


public class CreatePersistentObjectsTest extends TestCase {

    private TestProxySystem system;
    private TestProxyNakedObject adapter;
    private TestPojo pojo;
    private Oid oid;

    protected void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        system = new TestProxySystem();
        system.init();

        pojo = new TestPojo();
        adapter = system.createPersistentTestObject(pojo);
        oid = adapter.getOid();
    }

    public void testStateOfCreatedAdapted() {
        assertNotNull(adapter);
        assertEquals(new TestProxyOid(90000, true), oid);
        assertEquals(new TestProxyVersion(1), adapter.getVersion());
        assertEquals(ResolveState.RESOLVED, adapter.getResolveState());
        assertEquals(pojo, adapter.getObject());
    }
    
    public void testSpecification() {
        assertNotNull(adapter.getSpecification());
        assertNotNull(TestPojo.class.getName(), adapter.getSpecification().getFullName());
    }

    public void test2ndPersistentCreationHasDifferentOid() {
        TestPojo pojo = new TestPojo();
        TestProxyNakedObject adapter2 = system.createPersistentTestObject(pojo);

        assertNotNull(adapter2);
        assertEquals(new TestProxyOid(90001, true), adapter2.getOid());
    }

    public void testIsAddedToObjectLoader() throws Exception {
        NakedObject a = NakedObjectsContext.getObjectLoader().getAdapterFor(oid);
        assertEquals(adapter, a);
    }

    public void testAddedToPersistor() throws Exception {
        system.resetLoader();
        NakedObject a = NakedObjectsContext.getObjectPersistor().getObject(oid, null);
        assertEquals(adapter, a);
    }
}

// Copyright (c) Naked Objects Group Ltd.
