package org.nakedobjects.testing;

import java.util.Date;

import junit.framework.TestCase;

import org.nakedobjects.noa.adapter.Version;
import org.nakedobjects.noa.persist.ConcurrencyException;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.adapter.AbstractNakedReference;
import org.nakedobjects.nof.core.adapter.SerialNumberVersion;


public class AbstractNakedReferenceTest extends TestCase {

    public static void main(final String[] args) {
        junit.textui.TestRunner.run(AbstractNakedReferenceTest.class);
    }

    public void testCheckLock() {
        Version a1 = new SerialNumberVersion(1023L, "Tom", new Date(0L));
        Version a2 = new SerialNumberVersion(1023L, "Tom", new Date(0L));
        Version b = new SerialNumberVersion(932L, "Dick", new Date(200000L));

        DummyNakedReference dummy = new DummyNakedReference();
        dummy.setupSpecification(new TestSpecification());
        dummy.setOptimisticLock(a1);

        dummy.checkLock(a2);

        try {
            dummy.checkLock(b);
            fail();
        } catch (ConcurrencyException e) {}

    }

}

class DummyNakedReference extends AbstractNakedReference {

    private TestSpecification specification;

    public void setupSpecification(final TestSpecification specification) {
        this.specification = specification;
    }

    public Object getObject() {
        return null;
    }

    public String titleString() {
        return "Business Object";
    }

    public NakedObjectSpecification getSpecification() {
        return specification;
    }

}
// Copyright (c) Naked Objects Group Ltd.
