package org.nakedobjects.testing;

import java.util.Enumeration;
import java.util.Vector;

import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.adapter.Persistable;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.noa.adapter.Version;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.util.Assert;


public class DummyNakedCollection implements NakedCollection {
    private Vector collection = new Vector();
    private Oid oid;
    private ResolveState resolveState = ResolveState.GHOST;
    private NakedObjectSpecification specification;
    private Version version;
    private NakedObjectSpecification elementSpec = new TestSpecification();

    public DummyNakedCollection() {}

    public DummyNakedCollection(final Vector vector) {
        for(Enumeration e = vector.elements(); e.hasMoreElements(); ) {
            Object element = e.nextElement();
            collection.addElement(NakedObjectsContext.getObjectLoader().getAdapterForElseCreateAdapterForTransient(element));
            
            /*
            if(! (element instanceof NakedObject)) {
                throw new IllegalArgumentException("Element not of type NakedObject: " + element);
            }
            */
        }
        this.collection = vector;
    }

    public void checkLock(final Version version) {}

    public boolean contains(final NakedObject object) {
        return collection.contains(object);
    }

    public Enumeration elements() {
        return collection.elements();
    }

    public NakedObject firstElement() {
        return (NakedObject) collection.elementAt(0);
    }
    
    public NakedObjectSpecification getElementSpecification() {
        return elementSpec ;
    }

    public String getIconName() {
        return null;
    }

    public Object getObject() {
        return collection;
    }

    public Oid getOid() {
        return oid;
    }

    public ResolveState getResolveState() {
        return resolveState;
    }
    
    public NakedObjectSpecification getSpecification() {
        return specification;
    }

    public Version getVersion() {
        return version;
    }

    public void init(final NakedObject[] initElements) {
        Assert.assertEquals("Collection not empty", 0, this.collection.size());
        for (int i = 0; i < initElements.length; i++) {
            collection.addElement(initElements[i]);
        }
    }
    
    public void init(final Object[] initElements) {
        Assert.assertEquals("Collection not empty", 0, this.collection.size());
        for (int i = 0; i < initElements.length; i++) {
            collection.addElement(NakedObjectsContext.getObjectLoader().getAdapterForElseCreateAdapterForTransient(initElements[i]));
        }
    }

    public Persistable persistable() {
        return Persistable.USER_PERSISTABLE;
    }

    public void setOptimisticLock(final Version version) {}

    public void setupResolveState(final ResolveState resolveState) {
        this.resolveState = resolveState;
    }

    public void setupSpecification(final NakedObjectSpecification specification) {
        this.specification = specification;
    }

    public void setupOid(final Oid oid) {
        this.oid = oid;
    }

    public void setupElement(final NakedObject element) {
        collection.addElement(element);
    }

    public int size() {
        return collection.size();
    }

    public String titleString() {
        return "title";
    }

    public void setupVersion(final Version version) {
        this.version = version;
    }

    public void changeState(final ResolveState newState) {}
}
// Copyright (c) Naked Objects Group Ltd.
