package org.nakedobjects.testing;

import org.nakedobjects.noa.adapter.Oid;


public class DummyOid implements Oid {
    private static final long serialVersionUID = 1L;
    public int id;
    public Oid previous;
    public boolean isTransient = true;

    public DummyOid(final int id) {
        this.id = id;
    }

    public DummyOid(final int id, final boolean persistent) {
        this.id = id;
        this.isTransient = !persistent;
    }

    public boolean equals(final Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DummyOid) {
            return ((DummyOid) obj).id == id && ((DummyOid) obj).isTransient == isTransient;
        }
        return false;
    }

    public int hashCode() {
        return 37 * 17 + (int) (id ^ (id >>> 32)) + (isTransient ? 0 : 1);
    }

    public String toString() {
        return "DummyOid#" + id + (isTransient ? " T" : "") + (hasPrevious() ? " (" + previous + ")" : "");
    }

    public boolean hasPrevious() {
        return previous != null;
    }

    public Oid getPrevious() {
        return previous;
    }

    public void copyFrom(final Oid oid) {
        this.id = ((DummyOid) oid).id;
        this.isTransient = ((DummyOid) oid).isTransient;
    }

    public boolean isTransient() {
        return isTransient;
    }

    public void makePersistent() {
        id = -id;
        isTransient = false;
    }

    public boolean isNull() {
        return false;
    }

    public void setNull(final boolean isNull) {}
}
// Copyright (c) Naked Objects Group Ltd.
