package org.nakedobjects.testing;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedObjectLoader;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.noa.reflect.SpecObjectPair;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.adapter.value.IntAdapter;
import org.nakedobjects.nof.core.adapter.value.StringAdapter;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.UnexpectedCallException;

import test.org.nakedobjects.object.DummyException;


public class TestObjectLoader implements NakedObjectLoader {
    private static int oidSerialNumber = -1;
    private Hashtable collectionAdapters = new Hashtable();
    private Hashtable identites = new Hashtable();
    private Hashtable objectAdapters = new Hashtable();
    private Hashtable recreatedPersistent = new Hashtable();
    private Vector recreatedTransient = new Vector();
    private Hashtable valueAdapters = new Hashtable();

    public void addAdapter(final Object object, final NakedCollection collection) {
        collectionAdapters.put(object, collection);
    }

    public void addAdapter(final Object object, final NakedObject nakedobject) {
        objectAdapters.put(object, nakedobject);
    }

    public void addAdapter(final Object object, final NakedValue value) {
        valueAdapters.put(object, value);
    }

    public void addIdentity(final Oid oid, final NakedReference adapter) {
        identites.put(oid, adapter);
    }

    public void addRecreated(final Oid oid, final NakedReference adapter) {
        recreatedPersistent.put(oid, adapter);
    }

    public void addRecreatedTransient(final NakedReference adapter) {
        recreatedTransient.addElement(adapter);
    }

    public NakedCollection createAdapterForCollection(final Object collection, final NakedObjectSpecification specification) {
        DummyNakedCollection adapter = new DummyNakedCollection();
        return adapter;
    }

    /**
     * NB: this test version doesn't (seem to) support defaulting properties.
     */
    public NakedObject createAdapterForTransient(final Object object) {
        return createAdapterForTransient(object, true);
    }

    /**
     * NB: this test version doesn't (seem to) support defaulting properties, even if requested.
     */
    public NakedObject createAdapterForTransient(final Object object, boolean defaultProperties) {
        DummyNakedObject adapter = new DummyNakedObject();
        adapter.setupObject(object);
        adapter.setupResolveState(ResolveState.TRANSIENT);
        DummyOid oid = new DummyOid(oidSerialNumber--);
        adapter.setupOid(oid);
        NakedObjectSpecification spec = NakedObjectsContext.getReflector().loadSpecification(object.getClass());
        adapter.setupSpecification(spec);

        addAdapter(object, adapter);
        addIdentity(oid, adapter);

        return adapter;
    }

    public NakedValue createAdapterForValue(final Object value) {
        if (value instanceof Integer) {
            return new IntAdapter((Integer) value);
        } else if (value instanceof String) {
            return new StringAdapter((String) value);
        }

        throw new IllegalArgumentException("Can't create adapter for value " + value);
    }

    public NakedObject createTransientInstance(final NakedObjectSpecification specification) {
        throw new NakedObjectRuntimeException();
    }

    public NakedValue createValueInstance(final NakedObjectSpecification specification) {
        return new TestValueAdapter();
        /*
        
        return new AbstractValueAdapter() {

            public Class getValueClass() {
                return null;
            }

            public byte[] asEncodedString() {
                return null;
            }

            public void parseTextEntry(String text) {}

            public void restoreFromEncodedString(byte[] data) {}

            public void setMask(String mask) {}

            public String getIconName() {
                return null;
            }

            public Object getObject() {
                return null;
            }

            public String titleString() {
                return null;
            }
        };
        */
    }

    public void debugData(final DebugString debug) {
        throw new NakedObjectRuntimeException();
    }

    public String debugTitle() {
        throw new NakedObjectRuntimeException();
    }

    public void end(final NakedReference object) {
        ResolveState finalState = object.getResolveState().getEndState();
        ((DummyNakedObject) object).setupResolveState(finalState);
    }

    public NakedObject getAdapterFor(final Object object) {
        throw new NakedObjectRuntimeException();
    }

    public NakedObject getAdapterFor(final Oid oid) {
        processChangedOid(oid);

        NakedObject no = (NakedObject) identites.get(oid);
        if (no == null) {
            throw new DummyException("No object for oid: " + oid);
        }
        return no;
    }

    public NakedCollection getAdapterForElseCreateAdapterForCollection(
            final NakedObject parent,
            final String fieldName,
            final NakedObjectSpecification elementSpecification,
            final Object collection) {
        NakedCollection adapter = (NakedCollection) collectionAdapters.get(collection);
        if (adapter == null) {
            throw new DummyException("No adapter for collection: " + collection);
        }
        return adapter;
    }

    public NakedObject getAdapterForElseCreateAdapterForTransient(final Object object) {
        NakedObject adapter = (NakedObject) objectAdapters.get(object);
        if (adapter == null) {
            return createAdapterForTransient(object);
        }
        return adapter;
    }

    public Naked[] getAdapters(
            SpecObjectPair[] pairs) {
        throw new NakedObjectRuntimeException("Not implemented in TestObjectLoader");
    }
    
    public Naked getAdapter(
            SpecObjectPair pair) {
        throw new NakedObjectRuntimeException("Not implemented in TestObjectLoader");
    }
    
    public void addAdapterClass(
            Class valueClass,
            Class adapterClass) {
        throw new NakedObjectRuntimeException("Not implemented in TestObjectLoader");
    }


    public Object[] getServices() {
        throw new UnexpectedCallException();
    }

    public Enumeration getIdentifiedObjects() {
        throw new NakedObjectRuntimeException();
    }

    public void init() {}

    public void initDomainObject(Object domainObject) {}
    
    public boolean isIdentityKnown(final Oid oid) {
        return identites.containsKey(oid);
    }

    public void madePersistent(final NakedReference adapter) {
        Oid oid = adapter.getOid();
        /*
         * WARNING - changing the OID object that is already a key in the identity map messes up the hashing
         * so it can't be found afterwards. To work properly, remove the identity first then change the oid,
         * finally re-add to the map.
         */
        identites.remove(oid);
        NakedObjectsContext.getObjectPersistor().convertTransientToPersistentOid(oid);
        Assert.assertTrue("Adapter's pojo should exist in pojo map and return the adapter", objectAdapters.get(adapter
                .getObject()) == adapter);
        Assert.assertNull("Changed OID should not already map to a known adapter " + oid, identites.get(oid));
        identites.put(oid, adapter);
        adapter.changeState(ResolveState.RESOLVED);
    }

    private void processChangedOid(final Oid oid) {
        if (oid.hasPrevious()) {
            Oid previous = oid.getPrevious();
            NakedObject object = (NakedObject) identites.get(previous);
            if (object != null) {
                identites.remove(previous);
                Oid oidFromObject = object.getOid();
                oidFromObject.copyFrom(oid);
                identites.put(oidFromObject, object);
            }
        }
    }

    public NakedObject recreateAdapterForPersistent(final Oid oid, final NakedObjectSpecification spec) {
        DummyNakedObject adapter = new DummyNakedObject(oid, ResolveState.GHOST);
        Object pojo = ((TestSpecification) spec).newInstance();
        adapter.setupObject(pojo);
        adapter.setupSpecification(spec);

        addAdapter(pojo, adapter);
        addIdentity(oid, adapter);

        return adapter;

        /*
         * DummyNakedObject nakedObject = (DummyNakedObject) recreatedPersistent.get(oid); if (nakedObject ==
         * null) { throw new DummyException("No adapter for " + oid); } nakedObject.setupOid(oid); return
         * nakedObject;
         */
    }

    public NakedObject recreateAdapter(final Oid oid, final Object pojo) {
        DummyNakedObject adapter = new DummyNakedObject(oid, ResolveState.GHOST);
        // Object pojo = ((TestSpecification) spec).newInstance();
        adapter.setupObject(pojo);
        NakedObjectSpecification spec = NakedObjectsContext.getReflector().loadSpecification(pojo.getClass());
        adapter.setupSpecification(spec);
        /*
         * 
         * DummyNakedObject adapter = (DummyNakedObject) recreatedPersistent.get(oid); if (adapter == null) {
         * throw new DummyException("No adapter for " + oid); } adapter.setupOid(oid);
         */
        addAdapter(pojo, adapter);
        addIdentity(oid, adapter);

        return adapter;
    }

    public NakedCollection recreateCollection(final NakedObjectSpecification collectionSpecification, NakedObjectSpecification elementSpecification) {
        return new DummyNakedCollection();
    }

    public NakedObject recreateTransientInstance(final Oid oid, final NakedObjectSpecification spec) {
        DummyNakedObject adapter = new DummyNakedObject(oid, ResolveState.TRANSIENT);
        Object pojo = ((TestSpecification) spec).newInstance();
        adapter.setupObject(pojo);
        adapter.setupSpecification(spec);

        addAdapter(pojo, adapter);
        addIdentity(oid, adapter);

        return adapter;

        /*
         * NakedObject element = (NakedObject) recreatedTransient.elementAt(0);
         * recreatedTransient.removeElementAt(0); return element;
         */
    }

    public void reset() {}

    public void setServices(Object[] services) {}
    
    public void shutdown() {}

    public void start(final NakedReference object, final ResolveState targetState) {
        ((DummyNakedObject) object).setupResolveState(targetState);
    }

    public void unloaded(final NakedObject object) {
        throw new NakedObjectRuntimeException();
    }





}
// Copyright (c) Naked Objects Group Ltd.
