package org.nakedobjects.testing;

import java.util.Enumeration;
import java.util.Hashtable;

import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.reflect.NakedObjectReflector;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.util.DebugString;


public class TestSpecificationLoader implements NakedObjectReflector {
    private Hashtable specs = new Hashtable();

    public void addSpecification(final NakedObjectSpecification specification) {
        specs.put(specification.getFullName(), specification);
    }

    public NakedObjectSpecification[] allSpecifications() {
        NakedObjectSpecification[] specsArray;
        specsArray = new NakedObjectSpecification[specs.size()];
        int i = 0;
        Enumeration e = specs.elements();
        while (e.hasMoreElements()) {
            specsArray[i++] = (NakedObjectSpecification) e.nextElement();
        }
        return specsArray;
    }
    
    public void debugData(final DebugString debug) {
          NakedObjectSpecification[] list = allSpecifications();
        for (int i = 0; i < list.length; i++) {
            debug.appendln(list[i].getFullName());
        }
    }

    public String debugTitle() {
        return null;
    }

    public void init() {}

    public void installServiceSpecification(Class class1) {}

    public NakedObjectSpecification loadSpecification(final Class cls) {
        return loadSpecification(cls.getName());
    }

    public NakedObjectSpecification loadSpecification(final String name) {
        if (specs.containsKey(name)) {
            return (NakedObjectSpecification) specs.get(name);
        } else {
            throw new NakedObjectRuntimeException("no specification for " + name);
        }
    }

    public void shutdown() {}

    public NakedCollection createCollectionAdapter(Object collection, NakedObjectSpecification elementSpecification) {
        return null;
    }

    public NakedValue createValueAdapter(NakedObjectSpecification specification) {
        return null;
    }

    public NakedValue createValueAdapter(Object pojo) {
        return null;
    }

}
// Copyright (c) Naked Objects Group Ltd.
