package test.org.nakedobjects.objects.specification;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.adapter.value.StringAdapter;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.testing.TestSpecification;

import test.org.nakedobjects.objects.bom.Person;


class PersonNameField extends TestValueField {

    public void clearValue(final NakedObject inObject) {
        getPerson(inObject).setName("");
    }

    public String debugData() {
        return "";
    }

    public Naked get(final NakedObject fromObject) {
        return new StringAdapter(getPerson(fromObject).getName());
    }

    public String getId() {
        return "name";
    }

    public String getName() {
        return "Name";
    }

    private Person getPerson(final NakedObject inObject) {
        return (Person) inObject.getObject();
    }

    public NakedObjectSpecification getSpecification() {
        return new TestSpecification("java.lang.String");
    }

    public void initValue(final NakedObject inObject, final NakedValue value) {
        getPerson(inObject).setName((String) value.getObject());
    }

    public Consent isValueValid(final NakedObject inObject, final NakedValue value) {
        return Allow.DEFAULT;
    }

    public void setValue(final NakedObject inObject, final NakedValue value) {
        getPerson(inObject).setName((String) value.getObject());
    }
    
    public Object getExtension(
            Class cls) {
        return null;
    }

    public Class[] getExtensions() {
        return new Class[]{};
    }

}

// Copyright (c) Naked Objects Group Ltd.

public class PersonSpecification extends TestSpecification {

    public PersonSpecification() {
        fields = new NakedObjectField[] { new PersonNameField(), };
    }

    public String getFullName() {
        return Person.class.getName();
    }

    public NakedObjectAction getObjectAction(final NakedObjectAction.Type type, final String name) {
        return null;
    }

    public NakedObjectAction getObjectAction(
            final NakedObjectAction.Type type,
            final String name,
            final NakedObjectSpecification[] parameters) {
        return null;
    }

    public NakedObjectAction[] getObjectActions(final NakedObjectAction.Type type) {
        return null;
    }

    public String getPluralName() {
        return "People";
    }

    public String getShortName() {
        return "person";
    }

    public String getSingularName() {
        return "Person";
    }

    public String getTitle(final NakedObject naked) {
        return ((Person) naked.getObject()).title();
    }

    public boolean isObject() {
        return true;
    }

    public Object newInstance() {
        return new Person();
    }
}
