/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.map;

import junit.framework.TestCase;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedObjectLoader;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.noa.reflect.NakedObjectReflector;
import org.nakedobjects.noa.security.Session;
import org.nakedobjects.nof.core.adapter.map.ObjectLoaderImpl;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.context.StaticContext;
import org.nakedobjects.nof.testsystem.TestPojo;
import org.nakedobjects.nof.testsystem.TestProxyOid;
import org.nakedobjects.nof.testsystem.TestProxyReflector;
import org.nakedobjects.testing.TestSession;

public class ObjectLoaderImplTest
extends TestCase {
    private ObjectLoaderImpl objectLoader;

    protected void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        this.objectLoader = new ObjectLoaderImpl(){

            public void initDomainObject(Object domainObject) {
            }
        };
        NakedObjectsContext nakedObjects = StaticContext.createInstance();
        nakedObjects.setReflector((NakedObjectReflector)new TestProxyReflector());
        nakedObjects.setObjectLoader((NakedObjectLoader)this.objectLoader);
        nakedObjects.setSession((Session)new TestSession());
        NakedObjectsContext.getReflector().init();
        NakedObjectsContext.getObjectLoader().init();
    }

    public void testRecreateTransientAdapter() {
        TestProxyOid oid = new TestProxyOid(13, false);
        TestPojo object = new TestPojo();
        NakedObject adapter = this.objectLoader.recreateAdapter((Oid)oid, (Object)object);
        ObjectLoaderImplTest.assertEquals((Object)oid, (Object)adapter.getOid());
        ObjectLoaderImplTest.assertEquals((Object)object, (Object)adapter.getObject());
        ObjectLoaderImplTest.assertEquals((Object)ResolveState.TRANSIENT, (Object)adapter.getResolveState());
        ObjectLoaderImplTest.assertEquals(null, (Object)adapter.getVersion());
    }

    public void testRecreatePersistentAdapter() {
        TestProxyOid oid = new TestProxyOid(15, true);
        TestPojo object = new TestPojo();
        NakedObject adapter = this.objectLoader.recreateAdapter((Oid)oid, (Object)object);
        ObjectLoaderImplTest.assertEquals((Object)oid, (Object)adapter.getOid());
        ObjectLoaderImplTest.assertEquals((Object)object, (Object)adapter.getObject());
        ObjectLoaderImplTest.assertEquals((Object)ResolveState.GHOST, (Object)adapter.getResolveState());
        ObjectLoaderImplTest.assertEquals(null, (Object)adapter.getVersion());
    }
}

