/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapterTestCase;
import org.nakedobjects.nof.core.adapter.value.BooleanAdapter;

public class BooleanAdapterTest
extends AbstractValueAdapterTestCase {
    private BooleanAdapter value;

    protected void setUp() throws Exception {
        super.setUp();
        this.value = new BooleanAdapter(new Boolean(true));
        ((AbstractValueAdapterTestCase)this).value = this.value;
    }

    public void testParseFalseString() throws Exception {
        this.value.parseTextEntry("faLSe");
        BooleanAdapterTest.assertEquals((Object)new Boolean(false), (Object)this.value.booleanValue());
    }

    public void testParseTrueString() throws Exception {
        this.value.parseTextEntry("TRue");
        BooleanAdapterTest.assertEquals((Object)new Boolean(true), (Object)this.value.booleanValue());
    }

    public void testParseInvalidString() throws Exception {
        try {
            this.value.parseTextEntry("yes");
            BooleanAdapterTest.fail();
        }
        catch (TextEntryParseException textEntryParseException) {
            // empty catch block
        }
    }

    public void testTitle() throws Exception {
        BooleanAdapterTest.assertEquals((String)"True", (String)this.value.titleString());
    }

    public void testTitleWhenNotSet() throws Exception {
        this.value.reset();
        BooleanAdapterTest.assertEquals((String)"False", (String)this.value.titleString());
    }

    public void testEncode() throws Exception {
        BooleanAdapterTest.assertEquals((String)"T", (String)this.value.asEncodedString());
    }

    public void testDecode() throws Exception {
        this.value.restoreFromEncodedString("T");
        BooleanAdapterTest.assertEquals((Object)new Boolean(true), (Object)this.value.booleanValue());
    }

    public void testIsSet() {
        BooleanAdapterTest.assertEquals((boolean)true, (boolean)this.value.isSet());
    }

    public void testIsNotSet() {
        this.value.reset();
        BooleanAdapterTest.assertEquals((boolean)false, (boolean)this.value.isSet());
    }
}

