/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import junit.textui.TestRunner;
import org.nakedobjects.noa.adapter.InvalidEntryException;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapterTestCase;
import org.nakedobjects.nof.core.adapter.value.CharAdapter;

public class CharacterAdapterTest
extends AbstractValueAdapterTestCase {
    private CharAdapter value;

    public static void main(String[] args) {
        TestRunner.run(CharacterAdapterTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.value = new CharAdapter(new Character('r'));
        ((AbstractValueAdapterTestCase)this).value = this.value;
    }

    public void testIntegerValue() {
        CharacterAdapterTest.assertEquals((char)'r', (char)this.value.charValue().charValue());
    }

    public void testPClear() throws Exception {
        this.value.clear();
        CharacterAdapterTest.assertTrue((boolean)this.value.isEmpty());
    }

    public void testParseLongString() throws Exception {
        try {
            this.value.parseTextEntry("one");
            CharacterAdapterTest.fail();
        }
        catch (InvalidEntryException invalidEntryException) {
            // empty catch block
        }
    }

    public void testLengths() {
        CharacterAdapterTest.assertEquals((int)0, (int)this.value.getMaximumLength());
        CharacterAdapterTest.assertEquals((int)0, (int)this.value.getMinumumLength());
    }

    public void testOutputAsString() {
        CharacterAdapterTest.assertEquals((String)"r", (String)this.value.titleString());
    }

    public void testValidParse() throws Exception {
        this.value.parseTextEntry("t");
        CharacterAdapterTest.assertEquals((Object)new Character('t'), (Object)this.value.charValue());
    }

    public void testEncode() throws Exception {
        CharacterAdapterTest.assertEquals((String)"r", (String)this.value.asEncodedString());
    }

    public void testDecode() throws Exception {
        this.value.restoreFromEncodedString("Y");
        CharacterAdapterTest.assertEquals((char)'Y', (char)this.value.charValue().charValue());
    }
}

