/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import junit.textui.TestRunner;
import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapterTestCase;
import org.nakedobjects.nof.core.adapter.value.IntAdapter;
import org.nakedobjects.testing.TestSystem;

public class IntAdapterTest
extends AbstractValueAdapterTestCase {
    private IntAdapter value;

    public static void main(String[] args) {
        TestRunner.run(IntAdapterTest.class);
    }

    protected void setUp() throws Exception {
        new TestSystem().init();
        this.value = new IntAdapter(new Integer(32));
        ((AbstractValueAdapterTestCase)this).value = this.value;
    }

    public void testIntegerValue() {
        IntAdapterTest.assertEquals((int)32, (int)this.value.integerValue());
    }

    public void testInvalidParse() throws Exception {
        try {
            this.value.parseTextEntry("one");
            IntAdapterTest.fail();
        }
        catch (TextEntryParseException textEntryParseException) {
            // empty catch block
        }
    }

    public void testLengths() {
        IntAdapterTest.assertEquals((int)0, (int)this.value.getMaximumLength());
        IntAdapterTest.assertEquals((int)0, (int)this.value.getMinumumLength());
    }

    public void testTitleString() {
        IntAdapterTest.assertEquals((String)"32", (String)this.value.titleString());
        this.value.setValue(Integer.valueOf(1032));
        IntAdapterTest.assertEquals((String)"1,032", (String)this.value.titleString());
    }

    public void testParse() throws Exception {
        this.value.parseTextEntry("120");
        IntAdapterTest.assertEquals((int)120, (int)this.value.integerValue());
        this.value.parseTextEntry("1,20.0");
        IntAdapterTest.assertEquals((int)120, (int)this.value.integerValue());
    }
}

