/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import junit.textui.TestRunner;
import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapterTestCase;
import org.nakedobjects.nof.core.adapter.value.ShortAdapter;
import org.nakedobjects.testing.TestSystem;

public class ShortAdapterTest
extends AbstractValueAdapterTestCase {
    private ShortAdapter value;

    public static void main(String[] args) {
        TestRunner.run(ShortAdapterTest.class);
    }

    protected void setUp() throws Exception {
        new TestSystem().init();
        this.value = new ShortAdapter(new Short(32));
        ((AbstractValueAdapterTestCase)this).value = this.value;
    }

    public void testShortValue() {
        ShortAdapterTest.assertEquals((int)32, (int)this.value.shortValue().shortValue());
        this.value.setValue(Short.valueOf((short)-102));
        ShortAdapterTest.assertEquals((int)-102, (int)this.value.shortValue().shortValue());
    }

    public void testInvalidParse() throws Exception {
        try {
            this.value.parseTextEntry("one");
            ShortAdapterTest.fail();
        }
        catch (TextEntryParseException textEntryParseException) {
            // empty catch block
        }
    }

    public void testLengths() {
        ShortAdapterTest.assertEquals((int)0, (int)this.value.getMaximumLength());
        ShortAdapterTest.assertEquals((int)0, (int)this.value.getMinumumLength());
    }

    public void testOutputAsString() {
        ShortAdapterTest.assertEquals((String)"32", (String)this.value.titleString());
        this.value.setValue(Short.valueOf((short)-128));
        ShortAdapterTest.assertEquals((String)"-128", (String)this.value.titleString());
    }

    public void testParse() throws Exception {
        this.value.parseTextEntry("120");
        ShortAdapterTest.assertEquals((int)120, (int)this.value.shortValue().shortValue());
        this.value.parseTextEntry("1,20.0");
        ShortAdapterTest.assertEquals((int)120, (int)this.value.shortValue().shortValue());
    }
}

